clc
clear all
global N delta s r pi p P phi c z gamma beta
options=optimset('Display','iter','MaxFunEvals',200,'MaxIter',500,'NonlEqnAlgorithm','lm','TolFun',.000000001,'TolX',.000000001);

% Parameters

N=5;
DaysPerMonth=30*5/7;
s=.03/DaysPerMonth;
DaysPerYear=365*5/7;
r=.05/DaysPerYear;
c=0.433;  %  Vacancy cost calculated at location given in 'Directory' sheet in the spreadsheet
%  c=c+c;  %  Doubling of vacancy cost for Table 5 (shut this down)
z=0.71;
pi=xlsread('pi.xls');
p=pi(:,6)+1;
pi=pi(:,1:5);

% Endogenous variables

u=.055;
f=(1-u)*s/u;
theta=0.5;

%  Calculate P

Mat=eye(N)-((1-s)/(1+r))*pi;
Inv=Mat^(-1);
P=Inv*p;

%  Calibration

phi=f*theta^(-.5);
rho=f/theta;
Wstat=P(3)-c/rho;
UmVstat=(1+r)*z/(r+f+s)+f*Wstat/(r+f+s);
beta=(Wstat-UmVstat)/(P(3)-UmVstat);
Vstat=s*UmVstat/r;
Ustat=UmVstat+Vstat;

%  Solve dynamic model

%  Nash

X(1:N)=theta;
% Err=HMFNash(X)
 [Xs,fval]=fsolve(@HMFNash,X,options);
thetas=real(Xs);
for i=1:N
    fs(i,1)=phi*thetas(i)^.5;
    us(i,1)=s/(fs(i)+s);
end
load  HMFNash U V W 
Results=[us,fs,U,V,W,W,P,thetas'];
betaNash=beta;
UmVstatNash=UmVstat;

%  Credible

delta=3.95*s;
gamma=(P(3)-Wstat)/(1+r) -(P(3)+Vstat)/(1-delta)+(1+r)*(Wstat+Vstat-delta*Ustat-(1-delta)*z)/(1-delta)^2;
Wpstat=(1+r)*(Wstat+Vstat-delta*Ustat-(1-delta)*z)/(1-delta)-Vstat;
% Err=HMF(X)
 [Xs,fval]=fsolve(@HMF,X,options);
thetas=real(Xs);
for i=1:N
    fs(i,1)=phi*thetas(i)^.5;
    us(i,1)=s/(fs(i)+s);
end
load  HMF U V W Wp
Results=real([Results;[us,fs,U,V,W,Wp,P,thetas']]);

%  Hag-Man

z=0.932;
UmVstat=(1+r)*z/(r+f+s)+f*Wstat/(r+f+s);
beta=(Wstat-UmVstat)/(P(3)-UmVstat);
Vstat=s*UmVstat/r;
Ustat=UmVstat+Vstat;
X(1:N)=theta;
% Err=HMFNash(X)
 [Xs,fval]=fsolve(@HMFNash,X,options);
thetas=real(Xs);
for i=1:N
    fs(i,1)=phi*thetas(i)^.5;
    us(i,1)=s/(fs(i)+s);
end
load  HMFNash U V W 
Results=real([Results;[us,fs,U,V,W,W,P,thetas']]);

Results=[Results;[betaNash,beta,c,delta,gamma,z,0,0]];

%  Persistence of the driving force

x=[0,1,0,0,0];
for t=1:5*floor(DaysPerYear)
    IRF(t,1)=x*p;
    x=x*pi;
end
